*		CURSO:	IN79K - TRABAJO DE TESIS
*		ALUMNO:	ANTOINE SAURE VALENZUELA
*		PROFESOR:	ANDRES WEINTRAUB P
*		SEMESTRE:	OTONO 2001
*		MODELO:	PLANIFICACION FORESTAL Y CONSTRUCCION DE CAMINOS 
*				CON RESTRICCIONES DE ADYACENCIA (PFCCA)



*		DEFINICION DE LOS CONJUNTOS

Sets

	t		periodos
$include "periodos.inc"

	k		nodos
$include "nodos.inc"

	o(k)		origenes			
$include "origenes.inc"

	u		unidades de cosecha	
$include "unidades.inc"

	s(k)		salidas			
$include "salidas.inc"

	j(k) 		intersecciones
$include "intersecciones.inc"

	;


*		DECLARACION DE LOS ALIAS
		
		
		alias(u,uu) ;
		alias(k,kk) ;
		alias(t,tt) ;


*		CONTINUACION DEFINICION DE CONJUNTOS

Sets

	cx(k,kk)	caminos existentes
$include "camexist.inc"

	cp(k,kk)	caminos potenciales
$include "campot.inc"

	uv(u,uu)	adyacencia
$include "adyacencia.inc"

	uo(o,u)	unidades por origen
$include "unidxorig.inc"

	;

*		DECLARACION DE LOS PARAMETROS

Parameters

	a(u,t)		cantidad de madera producida por hectarea en la unidad u en t,
	Ar(u)			area de la unidad u,
	Up(k,kk,t)		capacidad de flujo de un camino construido en el arco k-kk en t,
	Ue(k,kk)		capacidad de un camino existente en el arco k-kk,
	zmin(t)		limite inferior de la demanda en t,
	zmax(t)		limite superior de la demanda en t,
	r(s,t)		precio de venta en el mercado s en t,
	p(u,t)		costo de produccion en la unidad u en t,
	d(k,kk,t)		costo de transporte por el arco k-kk en t,
	h(k,kk,t)		costo de construccion en el arco k-kk en t,
	q(o,t)		costo unitario de produccion en el origen o en el periodo t

;

$include "productividades.inc"
$include "areas.inc"
$include "costotransp.inc"
$include "costoconst.inc"

	q(o,t)	=	0.1 ;
	Up(k,kk,t)	=	129188.9 ;
	Ue(k,kk)	=	129188.9 ;
	zmin(t)	=	3000 ;
	zmax(t)	=	15000	;
	r(s,t)	=	35 ;
	p(u,t)	=	8 ;


*		DEFINICION DE VARIABLES

Variables

	Cto_Cos		costo cosecha
	Cto_Tte		costo transporte
	Cto_Pro		costo produccion en los origenes
	Cto_Const		costo construccion de caminos
	
	Cto_Total		costo total
	Benef			ventas
	FObj			funcion objetivo

	x(u,t)		si la unidad u es cosechada en el periodo t
	w(k,kk,t)		si el camino potencial que une k-kk es construido en el periodo t
	f(k,kk,t)		flujo de madera transportado en el arco k-kk en el periodo t
	z(s,t)		produccion de madera entregada en el destino s en el periodo t	

	;

*		NATURALEZA DE LAS VARIABLES

	Positive variable Cto_Cos ;
	Positive variable Cto_Tte ;
	Positive variable Cto_Pro ;
	Positive variable Cto_Const ;
	Positive variable Cto_Total ;
	Positive variable Benef ;
	Free Variable FObj ;

	Binary variable x ;
	Binary variable w ;
	Positive variable f ;
	Positive variable z ;



*		DECLARACION DE LAS RESTRICCIONES

Equations

	C_COS				costos de cosecha
	C_TTE				costos de transporte
	C_PRO				costos de produccion
	C_CON				costos de construccion
	T_CT				costos totales
	T_Be				ingresos totales
	func_obj			funcion objetivo

	cons_orig(o,t)		conservacion de flujos en los origenes para cada periodo
	cons_int(j,t)		conservacion de flujos en las intersecciones para cada periodo
	sat_dda(s,t)		satisfaccion de la demanda en los mercados para cada periodo
	lims_prod(t)		entrega acotada superiormente en cada mercado para cada periodo
	limi_prod(t)		entrega acotada inferiormente en cada mercado para cada periodo
	exis_flu(k,kk,t)		flujo en el arco k-kk debe ser menor que la capacidad si el camino potencial existe en el periodod t
	cons_cam(k,kk)		los caminos pueden ser construidos una sola vez en el horizonte de tiempo considerado
	cap_camext(k,kk,t)	el flujo en el arco existente k-kk debe ser menor que la capacidad de este para todos los periodos
	adj(u,uu,t)			restriccion de adyacencia en cada periodo
	exp_unid(u)			una unidad se explota solo una vez durante el horizonte

	;
*		DEFINICION DE LAS RESTRICCIONES


	cons_orig(o,t) ..
	sum(u$uo(o,u),a(u,t)*Ar(u)*x(u,t))+sum(k$(cx(k,o) or cp(k,o)),f(k,o,t))-sum(k$(cx(o,k) or cp(o,k)),f(o,k,t)) =e= 0 ;

	cons_int(j,t) ..
	sum(k$(cx(k,j) or cp(k,j)),f(k,j,t))-sum(k$(cx(j,k) or cp(j,k)),f(j,k,t)) =e= 0 ;
	
	sat_dda(s,t) ..
	z(s,t)=e= sum(k$(cx(k,s) or cp(k,s)),f(k,s,t)) ;

	lims_prod(t) ..
	sum(s,z(s,t)) =l= zmax(t) ;

	limi_prod(t) ..
	sum(s,z(s,t)) =g= zmin(t) ;


	exis_flu(k,kk,t)$cp(k,kk) ..
	f(k,kk,t) =l= Up(k,kk,t)*sum(tt$(ord(tt) le ord(t)),w(k,kk,tt)) ;

	cons_cam(k,kk) ..
	sum(t,w(k,kk,t)) =l= 1 ;

	cap_camext(k,kk,t)$cx(k,kk) ..
	f(k,kk,t) =l= Ue(k,kk) ;

	adj(u,uu,t)$uv(u,uu) ..
	x(u,t)+ x(uu,t) =l= 1 ;

	exp_unid(u) ..
	sum(t,x(u,t)) =l= 1 ;



*		DEFINICION DE LA FUNCION OBJETIVO

C_COS ..
	Cto_Cos =e= sum((u,t),x(u,t)*p(u,t)*Ar(u)) ;

C_TTE ..
	Cto_Tte =e=	sum((k,kk,t),d(k,kk,t)*f(k,kk,t)) ;

C_PRO ..
	Cto_Pro =e= sum((o,t),q(o,t)*sum(u$uo(o,u),Ar(u)*a(u,t)*x(u,t))) ;

C_CON ..
	Cto_Const =e= sum((k,kk,t),h(k,kk,t)*w(k,kk,t)) ;

T_CT .. 
	Cto_Total =e= Cto_Cos + Cto_Pro + Cto_Const + Cto_Tte ;

T_Be	..		
	Benef	  =e= sum((s,t), r(s,t)*z(s,t)) ;

func_obj ..	
	FObj	=e=	Benef - Cto_Total ;



*		CREACION Y EJECUCION DEL MODELO

MODEL PFCCA	/ all /;


OPTION ITERLIM = 10000000;
OPTION SYSOUT = ON;
OPTION RESLIM = 36000;
OPTION OPTCR = 0.1;
OPTION LIMROW = 20;
OPTION LIMCOL = 0;
PFCCA.prioropt = 1 ;
x.prior(u,t) = 1 ;
w.prior(k,kk,t) = 2 ;
PFCCA.optfile = 1;

SOLVE PFCCA USING MIP MAXIMIZING FObj ;


*		GENERACION DE REPORTES

file output /UnPer.txt/;

put output;
output.lw=0;
output.nw=0;
output.sw=0;
output.tw=0;
output.nd=0;
output.pw=1000;

put @5, "CURSO:         IN79K - TRABAJO DE TESIS"/;
put @5, "ALUMNO:        ANTOINE SAURE VALENZUELA"/;
put @5, "PROFESOR:      ANDRES WEINTRAUB P"/;
put @5, "SEMESTRE:      OTONO 2001"/;
put @5, "MODELO:        PLANIFICACION FORESTAL Y CONSTRUCCION DE CAMINOS"/;
put @5, "               CON RESTRICCIONES DE ADYACENCIA (PFCCA)"///;

put @10, "RESULTADOS"///;
put @5, " COSECHAS:"//;

loop(t,
	put @5,"Cosecha periodo ", t.tl, ":"/;
	loop(u,
		if(x.l(u,t)=1,put @10, u.tl/);
	);
put @5, ""/;
);
put @5, ""//;


put @5, "CAMINOS:"//;

loop(t,
	put @5,"Caminos construidos en el periodo ", t.tl, ":"/;
	loop((k,kk),
		if(w.l(k,kk,t)=1,put @10, "Desde ", k.tl, " hasta ", kk.tl/);
	);
put @5, ""/;
);
put @5, ""//;


put @5, "PRODUCCION:"//;

loop(t,
	put @5,"Oferta en el periodo ", t.tl, ":"/;
	loop(s,
		if(z.l(s,t) > 0,put @10, z.l(s,t), " en el mercado ", s.tl/);
	);
	put @5, "Produccion total en el periodo ", t.tl, ": ", sum(s,z.l(s,t))//;
);
put @5, ""//;








